/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.com.mongodb;

import net.impactdev.impactor.relocations.com.mongodb.BasicDBObject;
import net.impactdev.impactor.relocations.com.mongodb.DBObjects;
import net.impactdev.impactor.relocations.com.mongodb.MongoCommandException;
import net.impactdev.impactor.relocations.com.mongodb.MongoException;
import net.impactdev.impactor.relocations.com.mongodb.ServerAddress;
import net.impactdev.impactor.relocations.com.mongodb.assertions.Assertions;
import net.impactdev.impactor.relocations.com.mongodb.lang.Nullable;
import net.impactdev.impactor.relocations.org.bson.BsonDocument;

public class CommandResult
extends BasicDBObject {
    private static final long serialVersionUID = 5907909423864204060L;
    private final BsonDocument response;
    private final ServerAddress address;

    CommandResult(BsonDocument response) {
        this(response, null);
    }

    CommandResult(BsonDocument response, @Nullable ServerAddress address) {
        this.address = address;
        this.response = Assertions.notNull("response", response);
        this.putAll(DBObjects.toDBObject(response));
    }

    public boolean ok() {
        Object okValue = this.get("ok");
        if (okValue instanceof Boolean) {
            return (Boolean)okValue;
        }
        if (okValue instanceof Number) {
            return ((Number)okValue).intValue() == 1;
        }
        return false;
    }

    @Nullable
    public String getErrorMessage() {
        Object foo = this.get("errmsg");
        if (foo == null) {
            return null;
        }
        return foo.toString();
    }

    @Nullable
    public MongoException getException() {
        if (!this.ok()) {
            return this.createException();
        }
        return null;
    }

    public void throwOnError() {
        if (!this.ok()) {
            throw this.createException();
        }
    }

    private MongoException createException() {
        return new MongoCommandException(this.response, this.address);
    }
}

